using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		/// Panel used to display demographic information on patient
		///</summary>

		#endregion


	public class PatientDisplayPanel : GUI.controls.BaseControl
	{
		
		#region Events

		private System.EventHandler onSIAndTRClick;
		private System.EventHandler onBloodAvailClick;
		private System.EventHandler onVbecsInfoClick;
		private System.EventHandler onMedicationsClick;
		private System.EventHandler onTransHistoryClick;
		private System.EventHandler onClinicalInfoClick;
		
		#endregion

		private BOL.Patient _patient;

		#region Controls

		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpPatient;
		private System.Windows.Forms.TextBox txtABORh;
		private System.Windows.Forms.Label lblABORh;
		private System.Windows.Forms.TextBox txtSSN;
		private System.Windows.Forms.TextBox txtName;
		private System.Windows.Forms.Label lblSSN;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ImageList imageList1;
		private gov.va.med.vbecs.GUI.controls.PatientInfoToolbar patientInfoToolbar1;
		private System.Windows.Forms.PictureBox picJustified;
		private System.ComponentModel.IContainer components;

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// PatientDisplayPanel class constructor
		/// </summary>
		public PatientDisplayPanel()
		{
			InitializeComponent();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// PatientDisplayPanel class constructor, takes patient to display
		/// </summary>
		/// <param name="patient"></param>
		public PatientDisplayPanel(BOL.Patient patient)
		{
			InitializeComponent();
			//
			try
			{
				//Must be in a try/catch block, else it will cause error when used in design time
				this.Patient = patient;
			}
			catch
			{
			}
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion


		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PatientDisplayPanel));
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpPatient = new System.Windows.Forms.GroupBox();
			this.picJustified = new System.Windows.Forms.PictureBox();
			this.patientInfoToolbar1 = new gov.va.med.vbecs.GUI.controls.PatientInfoToolbar();
			this.txtABORh = new System.Windows.Forms.TextBox();
			this.lblABORh = new System.Windows.Forms.Label();
			this.txtSSN = new System.Windows.Forms.TextBox();
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblSSN = new System.Windows.Forms.Label();
			this.lblName = new System.Windows.Forms.Label();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.groupBox2.SuspendLayout();
			this.grpPatient.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.pictureBox1);
			this.groupBox2.Location = new System.Drawing.Point(0, 0);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(40, 40);
			this.groupBox2.TabIndex = 1;
			this.groupBox2.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(28, 28);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpPatient
			// 
			this.grpPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatient.Controls.Add(this.picJustified);
			this.grpPatient.Controls.Add(this.patientInfoToolbar1);
			this.grpPatient.Controls.Add(this.txtABORh);
			this.grpPatient.Controls.Add(this.lblABORh);
			this.grpPatient.Controls.Add(this.txtSSN);
			this.grpPatient.Controls.Add(this.txtName);
			this.grpPatient.Controls.Add(this.lblSSN);
			this.grpPatient.Controls.Add(this.lblName);
			this.grpPatient.Location = new System.Drawing.Point(44, 0);
			this.grpPatient.Name = "grpPatient";
			this.grpPatient.Size = new System.Drawing.Size(654, 40);
			this.grpPatient.TabIndex = 0;
			this.grpPatient.TabStop = false;
			// 
			// picJustified
			// 
			this.picJustified.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.picJustified.Image = ((System.Drawing.Image)(resources.GetObject("picJustified.Image")));
			this.picJustified.Location = new System.Drawing.Point(462, 14);
			this.picJustified.Name = "picJustified";
			this.picJustified.Size = new System.Drawing.Size(16, 16);
			this.picJustified.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picJustified.TabIndex = 60;
			this.picJustified.TabStop = false;
			this.toolTip1.SetToolTip(this.picJustified, "The patient has a history of  justified ABO/Rh change");
			this.picJustified.Visible = false;
			// 
			// patientInfoToolbar1
			// 
			this.patientInfoToolbar1.AccessibleDescription = "Patient Information";
			this.patientInfoToolbar1.AccessibleName = "Patient Information";
			this.patientInfoToolbar1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.patientInfoToolbar1.EnabledBloodAvailButton = false;
			this.patientInfoToolbar1.EnabledMedicationButton = false;
			this.patientInfoToolbar1.EnabledRecentOrdersButton = false;
			this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientInfoToolbar1.EnabledSIAndTRButton = false;
			this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton = false;
			this.patientInfoToolbar1.Location = new System.Drawing.Point(492, 12);
			this.patientInfoToolbar1.Name = "patientInfoToolbar1";
			this.patientInfoToolbar1.ParentFormInstanceGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.patientInfoToolbar1.Patient = null;
			this.patientInfoToolbar1.Size = new System.Drawing.Size(154, 20);
			this.patientInfoToolbar1.TabIndex = 4;
			// 
			// txtABORh
			// 
			this.txtABORh.AccessibleDescription = "A B O R h";
			this.txtABORh.AccessibleName = "A B O R h";
			this.txtABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtABORh.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtABORh.Location = new System.Drawing.Point(404, 12);
			this.txtABORh.Name = "txtABORh";
			this.txtABORh.ReadOnly = true;
			this.txtABORh.Size = new System.Drawing.Size(76, 20);
			this.txtABORh.TabIndex = 3;
			this.txtABORh.Text = "";
			// 
			// lblABORh
			// 
			this.lblABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblABORh.Location = new System.Drawing.Point(360, 12);
			this.lblABORh.Name = "lblABORh";
			this.lblABORh.Size = new System.Drawing.Size(52, 20);
			this.lblABORh.TabIndex = 4;
			this.lblABORh.Text = "ABO/Rh";
			this.lblABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSSN
			// 
			this.txtSSN.AccessibleDescription = "Patient I D";
			this.txtSSN.AccessibleName = "Patient I D";
			this.txtSSN.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtSSN.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtSSN.Location = new System.Drawing.Point(264, 12);
			this.txtSSN.Name = "txtSSN";
			this.txtSSN.ReadOnly = true;
			this.txtSSN.Size = new System.Drawing.Size(92, 20);
			this.txtSSN.TabIndex = 2;
			this.txtSSN.Text = "";
			// 
			// txtName
			// 
			this.txtName.AccessibleDescription = "Name";
			this.txtName.AccessibleName = "Name";
			this.txtName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtName.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtName.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtName.Location = new System.Drawing.Point(40, 12);
			this.txtName.Name = "txtName";
			this.txtName.ReadOnly = true;
			this.txtName.Size = new System.Drawing.Size(172, 20);
			this.txtName.TabIndex = 1;
			this.txtName.Text = "";
			// 
			// lblSSN
			// 
			this.lblSSN.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblSSN.Location = new System.Drawing.Point(216, 12);
			this.lblSSN.Name = "lblSSN";
			this.lblSSN.Size = new System.Drawing.Size(56, 20);
			this.lblSSN.TabIndex = 2;
			this.lblSSN.Text = "Patient ID";
			this.lblSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 12);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(52, 20);
			this.lblName.TabIndex = 0;
			this.lblName.Text = "Name";
			this.lblName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// PatientDisplayPanel
			// 
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.grpPatient);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "PatientDisplayPanel";
			this.Size = new System.Drawing.Size(700, 40);
			this.groupBox2.ResumeLayout(false);
			this.grpPatient.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		#region EventHandlers

		/// <summary>
		/// Event that handles the click on special instructions and transfusion requirements button
		/// </summary>
		public event EventHandler SIAndTRClick
		{
			add
			{
				onSIAndTRClick += value;
			}
			remove
			{
				onSIAndTRClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the blood availability button
		/// </summary>
		public event EventHandler BloodAvailClick
		{
			add
			{
				onBloodAvailClick += value;
			}
			remove
			{
				onBloodAvailClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the display patient VBECS data
		/// </summary>
		public event EventHandler VbecsInfoClick
		{
			add
			{
				onVbecsInfoClick += value;
			}
			remove
			{
				onVbecsInfoClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the patient medications button
		/// </summary>
		public event EventHandler MedicationsClick
		{
			add
			{
				onMedicationsClick += value;
			}
			remove
			{
				onMedicationsClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the transfusion history button
		/// </summary>
		public event EventHandler TransHistoryClick
		{
			add
			{
				onTransHistoryClick += value;
			}
			remove
			{
				onTransHistoryClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the patient clinical data button
		/// </summary>
		public event EventHandler ClinicalInfoClick
		{
			add
			{
				onClinicalInfoClick += value;
			}
			remove
			{
				onClinicalInfoClick -= value;
			}
		}

		#endregion


		#region Control Events

		/// <summary>
		/// Calls the event when special instructions and patient transfusion requirements button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSpecialInstructions_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onSIAndTRClick != null)
			{
				onSIAndTRClick(sender,e);
			}
		}
		/// <summary>
		/// Calls the event when blood availability button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnBloodAvailability_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onBloodAvailClick != null)
			{
				onBloodAvailClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient VBECS data button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnPatientInfo_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onVbecsInfoClick != null)
			{
				onVbecsInfoClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient current medications button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCurrentMeds_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			
			if (onMedicationsClick != null)
			{
				onMedicationsClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient transfusion history button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnTransfusionHistory_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			
			if (onTransHistoryClick != null)
			{
				onTransHistoryClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient clinical data button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClinicalData_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			
			if (onClinicalInfoClick != null)
			{
				onClinicalInfoClick(sender,e);
			}
		}

		#endregion


		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets patient to display in control
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				this._patient = value;
				this.patientInfoToolbar1.Patient = value;
				//
				if (this._patient != null)
				{
					DisplayPatient();
				}
				else
				{
					this.txtName.Text = "";
					this.txtSSN.Text = "";
					this.txtABORh.Text = "";
					this.toolTip1.SetToolTip(this.txtABORh, "");
					this.picJustified.Visible = false;
				}
			}
		}

		/// <summary>
		/// Get PatientInfoToolbar
		/// </summary>
		public controls.PatientInfoToolbar PatientInfoToolbar
		{
			get
			{
				return this.patientInfoToolbar1;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Gets or sets docking style property
		/// </summary>
		[
		Category("Layout"),
		Description("Docking style"),
		Bindable(false),
		Browsable(true),
		]
		public override DockStyle Dock 
		{
			get { return base.Dock; }
			set { base.Dock = value; }
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary> 
		/// Gets or sets anchor style property
		/// </summary>
		[
		Category("Layout"),
		Description("Anchor style"),
		Bindable(false),
		Browsable(true),
		]
		public override AnchorStyles Anchor
		{
			get { return base.Anchor; }
			set { base.Anchor = value; }
		}

		private void DisplayPatient()
		{
			this.OnUserActivity();

			this.txtName.Text = this._patient.DisplayName;
			BOL.AboRh patientAboRh = BOL.Patient.GetPatientAboRh(this._patient.PatientGuid);
			this.txtABORh.Text = patientAboRh.AboRHText;
			this.toolTip1.SetToolTip(this.txtABORh, this._patient.GetPatientHistoricABORhForTooltip());
			this.picJustified.Visible = (this._patient.JustifiedAboRH);
		    //this.txtSSN.Text = this._patient.DisplayPatientID;
            //CR 3467
            this.txtSSN.Text = this._patient.SSN.Insert(3, "-").Insert(6, "-");
		}
		
		/// <summary>
		/// Indicates whether the SI and TR button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the SI & TR button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledSIAndTRButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledSIAndTRButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledSIAndTRButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the blood availability button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the blood availability button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledBloodAvailButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledBloodAvailButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledBloodAvailButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Recent Orders button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Recent Orders button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledRecentOrdersButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledRecentOrdersButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledRecentOrdersButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Medication Profile button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Medication Profile button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledMedicationButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledMedicationButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledMedicationButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Recent Transfusions/Issues button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Recent Transfusions/Issues button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledRecentTransfusionsIssuesButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Transfusion Reaction History button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Transfusion Reaction History button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledTransfusionReactionHistoryButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton = value;
			}
		}

		#endregion

	    #region Properties

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <returns></returns>
		public string GetErrorMessagesFor508()
		{
			string textToSpeak = string.Empty;
			if(this.picJustified.Visible)
			{
				textToSpeak = "The patient has a history of  justified ABO/Rh change";
			}
			return textToSpeak;
		}

		#endregion
	}
}
